function test_suite = testPut_in_arrays %#ok<*STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertTrue(isempty(p.put_in_arrays))

function testDefault
p = polysym;
assertEqual(p.put_in_arrays,{p})

function testSingleChar
p = polysym('x');
assertEqual(p.put_in_arrays,{p})

function testSingleArray
p = polysym('x',[2 3]);
assertEqual(p.put_in_arrays,{p})

function testIncompleteArray
polysyms('x1_2','x2_3')
p = [x1_2 x2_3];
assertEqual(p.put_in_arrays,{p(1); p(2)})

function testColumnVector
p = polysym('x',[3 1]);
assertEqual(p.put_in_arrays,{p})

function testRowVector
p = polysym('x',[1 3]);
assertEqual(p.put_in_arrays,{p(:)})

function testVectorIncomplete
polysyms('x1','x3')
p = [x1 x3];
assertEqual(p.put_in_arrays,{p(1); p(2)})

function testMultipleChars
polysyms('x','y')
p = [x y];
assertEqual(p.put_in_arrays,{x; y})

function testMixed
p = polysym('w',2);
q = polysym(pi);
r = polysym('x',[3 1]);
v = [p(:); q; r];
assertEqual(v.put_in_arrays,{q; p; r})

function testSameRoot
% The arrays x and p interfere with each other, resulting in all the
% components being listed. It seems unlikely that a user will want to
% define variables this way.
p = polysym('x',[1 2]);
x = polysym('x');
v = [p(:); x];
assertEqual(v.put_in_arrays,{p(1); p(2); x})

function testOverlap
% Repetitions in terms are ignored.
polysyms x1 x2 x3
v = [x1 x2 x2 x3];
assertEqual(v.put_in_arrays,{[x1; x2; x3]})

function testOneIndex
polysyms l0 l1
assertEqual(put_in_arrays([l0 l1]),{l0; l1})